import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class ImageQualitySection extends StatefulWidget {
  const ImageQualitySection({Key? key}) : super(key: key);

  @override
  _ImageQualitySectionState createState() => _ImageQualitySectionState();
}

class _ImageQualitySectionState extends State<ImageQualitySection> with AppActiveContentMixin {
  @override
  build(context) {
    return FormEditorPage(
      heading: 'Image Quality Options',
      description: 'Upload process stores both the original and a compressed version of same image.'
          'Compressed version of image is used on places where load times are critical.',
      items: [
        SettingItem(
          intId: AppSettings.ID_SS_INT_COMPRESS_USER_DISPLAY_IMAGE_FILE_QUALITY,
          settingKey: AppSettings.KEY_SS_INT_COMPRESS_USER_DISPLAY_IMAGE_FILE_QUALITY,
          type: FieldType.text,
          leading: 'Compressed Quality - User Images',
          placeholder: 'e.g 85',
          description: "Must be between 1 and 100",
        ),
        SettingItem(
          intId: AppSettings.ID_SS_INT_COMPRESS_POST_DISPLAY_IMAGE_FILE_QUALITY,
          settingKey: AppSettings.KEY_SS_INT_COMPRESS_POST_DISPLAY_IMAGE_FILE_QUALITY,
          type: FieldType.text,
          leading: 'Compressed Quality - Post Images',
          placeholder: 'e.g 85',
          description: "Must be between 1 and 100",
        ),
        SettingItem(
          intId: AppSettings.ID_SS_INT_COMPRESS_COLLECTION_COVER_IMAGE_FILE_QUALITY,
          settingKey: AppSettings.KEY_SS_INT_COMPRESS_COLLECTION_COVER_IMAGE_FILE_QUALITY,
          type: FieldType.text,
          leading: 'Compressed Quality - Collection Cover',
          placeholder: 'e.g 85',
          description: "Must be between 1 and 100",
        ),
      ],
    );
  }
}
